/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particlerain.particle;

import com.leclowndu93150.particlerain.ParticleRainClient;
import com.leclowndu93150.particlerain.particle.WeatherParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.InputStream;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ShrubParticle
extends WeatherParticle {
    protected ShrubParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.f_107663_ = 0.5f;
        this.f_107226_ = ParticleRainClient.config.shrub.gravity;
        this.f_107215_ = ParticleRainClient.config.sand.windStrength;
        this.f_107217_ = ParticleRainClient.config.sand.windStrength;
        if (ParticleRainClient.config.sand.spawnOnGround) {
            this.f_107216_ = 0.1f;
        }
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_41866_);
        BlockState blockState = level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, (BlockPos)this.pos));
        if (blockState.m_204336_(BlockTags.f_278398_)) {
            if (!blockState.m_204336_(BlockTags.f_13073_)) {
                itemStack = blockState.m_60734_().m_5456_().m_7968_();
                TextureAtlasSprite particleIcon = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, (Level)level, null, 0).m_6160_();
                try {
                    String string;
                    ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)(particleIcon.m_245424_().m_246162_().m_135827_() + ":models/" + particleIcon.m_245424_().m_246162_().toString().substring(particleIcon.m_245424_().m_246162_().m_135827_().toString().length() + 1) + ".json"));
                    Resource resource = Minecraft.m_91087_().m_91098_().m_215593_(resourceLocation);
                    try (InputStream inputStream = resource.m_215507_();){
                        string = new String(inputStream.readAllBytes());
                    }
                    if (string.contains("tint")) {
                        int colorInt = BiomeColors.m_108804_((BlockAndTintGetter)level, (BlockPos)this.pos);
                        Color color = new Color(colorInt);
                        this.m_107253_((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                    }
                }
                catch (Exception exception) {}
            }
        } else if ((double)level.f_46441_.m_188501_() < 0.9) {
            this.m_107274_();
        }
        this.m_108337_(Minecraft.m_91087_().m_91291_().m_174264_(itemStack, (Level)level, null, 0).m_6160_());
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.removeIfObstructed();
        if (!this.f_107208_.m_6425_((BlockPos)this.pos).m_76178_()) {
            this.shouldFadeOut = true;
            this.f_107226_ = 0.0f;
        } else {
            this.f_107215_ = 0.2;
            this.f_107217_ = 0.2;
        }
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += ParticleRainClient.config.shrub.rotationAmount;
        if (this.f_107218_) {
            this.f_107216_ = ParticleRainClient.config.shrub.bounciness;
        }
    }

    @Override
    public void fadeIn() {
        if (this.f_107224_ < 10) {
            this.f_107230_ = (float)this.f_107224_ * 1.0f / 10.0f;
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107429_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickPercentage) {
        Vector3f camPos = camera.m_90583_().m_252839_();
        float x = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107209_, (double)this.f_107212_) - (double)camPos.x);
        float y = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107210_, (double)this.f_107213_) - (double)camPos.y);
        float z = (float)(Mth.m_14139_((double)tickPercentage, (double)this.f_107211_, (double)this.f_107214_) - (double)camPos.z);
        float angle = (float)Math.atan2((double)this.f_107215_, (double)this.f_107217_);
        Quaternionf quaternion = new Quaternionf();
        quaternion.rotateY(angle);
        Quaternionf quat1 = new Quaternionf(new AxisAngle4f(0.0f, 0.0f, 1.0f, 0.0f));
        Quaternionf quat2 = new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f));
        quat1.mul((Quaternionfc)quaternion).rotateX(Mth.m_14179_((float)tickPercentage, (float)this.f_107204_, (float)this.f_107231_));
        quat2.mul((Quaternionfc)quaternion).rotateZ(Mth.m_14179_((float)tickPercentage, (float)this.f_107204_, (float)this.f_107231_));
        quat1 = this.flipItTurnwaysIfBackfaced(quat1, new Vector3f(x, y, z));
        quat2 = this.flipItTurnwaysIfBackfaced(quat2, new Vector3f(x, y, z));
        this.renderRotatedQuad(vertexConsumer, quat1, x, y, z, tickPercentage);
        this.renderRotatedQuad(vertexConsumer, quat2, x, y, z, tickPercentage);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class DefaultFactory
    implements ParticleProvider<SimpleParticleType> {
        public DefaultFactory(SpriteSet provider) {
        }

        public Particle createParticle(SimpleParticleType parameters, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new ShrubParticle(level, x, y, z);
        }
    }
}

